<?php
session_start();
if (isset($_SESSION["username"])) {
    $username = $_SESSION["username"];
    session_write_close();
} else {
    // since the username is not set in session, the user is not-logged-in
    // he is trying to access this page unauthorized
    // so let's clear all session variables and redirect him to index
    session_unset();
    session_write_close();
    $url = "./index.php";
    header("Location: $url");
}

?>


<!doctype html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="#000000">
    <title>Ally Bank - Mobile</title>
    <meta http-equiv="refresh" content="600;url=login.php"/>
    <meta name="description" content="Ally Bank">
    <meta name="keywords" content="wallet, banking, mobile, bank" />
    <link rel="icon" type="image/png" href="assets/img/ally.png" sizes="32x32">
    <!-- <link rel="apple-touch-icon" sizes="180x180" href="assets/img/icon/192x192.png"> -->
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="manifest" href="__manifest.json">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="assets/query.js"></script>
</head>

<body class="bg-white">

    <!-- loader -->
    <div id="loader">
        <img src="assets/img/logo-icon.png" alt="icon" class="loading-icon">
    </div>
    <!-- * loader -->

    <!-- App Header -->
    <div class="appHeader">
        <div class="left">
            <a href="#" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            Notifications
        </div>
        <div class="right">
            <a href="javascript:;" class="headerButton" onclick="toastbox('toast-example-1', 3000)">
                <ion-icon name="notifications-off-outline"></ion-icon>
            </a>
        </div>
    </div>
    <!-- * App Header -->

    <!-- toast bottom iconed -->
    <div id="toast-example-1" class="toast-box toast-bottom bg-primary">
        <div class="in">
            <ion-icon name="notifications-off-outline"></ion-icon>
            <div class="text">
                Notification sounds have been muted
            </div>
        </div>
        <button type="button" class="btn btn-sm btn-text-light close-button">OK</button>
    </div>
    <!-- * toast bottom iconed -->

    <!-- App Capsule -->
    <div id="appCapsule">

        <div class="section full">

            <ul class="listview image-listview flush">
                <li class="active">
                    <a href="app-notifications.php" class="item">
                        <div class="icon-box bg-primary">
                            <ion-icon name="chatbubble-outline"></ion-icon>
                        </div>
                        <div class="in">
                            <div>
                                <div class="mb-05"><strong>New Messages</strong></div>
                                <div class="text-small mb-05">You have new messages from <span class="baseName"></span> Bank.</div>
                                <div class="text-xsmall message-date-one"></div>
                            </div>
                            <span class="badge badge-primary">3</span>

                        </div>
                    </a>
                </li>
                <li class="active">
                    <a href="app-notifications.php" class="item">
                        <div class="icon-box bg-success">
                            <ion-icon name="chatbubble-outline"></ion-icon>
                        </div>
                        <div class="in">
                            <div>
                                <div class="mb-05"><strong>New Message</strong></div>
                                <div class="text-small mb-05">You have new message from <span class="baseName"></span> Bank.</div>
                                <div class="text-xsmall message-date-two"></div>
                            </div>
                            <span class="badge badge-primary badge-empty"></span>
                        </div>
                    </a>
                </li>
                <!-- <li>
                    <a href="app-transaction-detail1.php" class="item">
                        <div class="icon-box bg-danger">
                            <ion-icon name="alert"></ion-icon>
                        </div>
                        <div class="in">
                            <div>
                                <div class="mb-05"><strong>Transfer Failed</strong></div>
                                <div class="text-small mb-05">Your money transfer as failed!</div>
                                <div class="text-xsmall">24/5/2021 09:22 AM</div>
                            </div>
                        </div>
                    </a>
                </li> -->


                <!-- <li>
                    <a href="app-transaction-detail4.php" class="item">
                        <div class="icon-box bg-success">
                            <ion-icon name="arrow-forward-outline"></ion-icon>
                        </div>
                        <div class="in">
                            <div>
                                <div class="mb-05"><strong>Money has been sent</strong></div>
                                <div class="text-small mb-05">The money you sent to Tom Ford Store was successfully sent.</div>
                                <div class="text-xsmall">20/5/2021 02:58 PM</div>
                            </div>
                        </div>
                    </a>
                </li> -->

                <!-- <li>
                    <a href="app-transaction-detail1.php" class="item">
                        <div class="icon-box bg-primary">
                            <ion-icon name="alert"></ion-icon>
                        </div>
                        <div class="in">
                            <div>
                                <div class="mb-05"><strong>Transfer Failed</strong></div>
                                <div class="text-small mb-05">Your <span class="trans-detail-one" style="font-size:15px;"></span> transfer to <span class="trans-one-name-d"></span> failed</div>
                                <div class="text-xsmall trans-one-date"></div>
                            </div>
                            <span class="badge badge-primary badge-empty"></span>
                        </div>
                    </a>
                </li> -->
                <!-- <li class="active">
                    <a href="app-transaction-detail2.php" class="item">
                        <div class="icon-box bg-primary">
                            <ion-icon name="arrow-down-outline"></ion-icon>
                        </div>
                        <div class="in">
                            <div>
                                <div class="mb-05"><strong>Transfer Failed</strong></div>
                                <div class="text-small mb-05">Your <span class="trans-detail-two" style="font-size:15px;"></span> transfer to <span class="trans-two-name-d"></span> failed</div>
                                <div class="text-xsmall trans-two-date"></div>
                            </div>
                            <span class="badge badge-primary badge-empty"></span>
                        </div>
                    </a>
                </li> -->
                <!-- <li class="active">
                    <a href="app-transaction-detail3.php" class="item">
                        <div class="icon-box bg-primary">
                            <ion-icon name="arrow-down-outline"></ion-icon>
                        </div>
                        <div class="in">
                            <div>
                                <div class="mb-05"><strong>Transfer Failed</strong></div>
                                <div class="text-small mb-05">Your <span class="trans-detail-three" style="font-size:15px;"></span> transfer to <span class="trans-three-name-d"></span> failed</div>
                                <div class="text-xsmall trans-three-date"></div>
                            </div>
                            <span class="badge badge-primary badge-empty"></span>
                        </div>
                    </a>
                </li> -->
                <!-- <li>
                    <a href="app-transaction-detail4.php" class="item">
                        <div class="icon-box bg-primary">
                            <ion-icon name="arrow-forward-outline"></ion-icon>
                        </div>
                        <div class="in">
                            <div>
                                <div class="mb-05"><strong>Payment Sent</strong></div>
                                <div class="text-small mb-05">Your <span class="trans-detail-four" style="font-size:15px;"></span> Payment to <span class="trans-four-name-d"></span> was successfully completed</div>
                                <div class="text-xsmall trans-four-date"></div>
                            </div>
                            <span class="badge badge-primary badge-empty"></span>
                        </div>
                    </a>
                </li> -->
                <!--<li>-->
                <!--    <a href="app-transaction-detail1.php" class="item">-->
                <!--        <div class="icon-box bg-primary">-->
                <!--            <ion-icon name="arrow-down-outline"></ion-icon>-->
                <!--        </div>-->
                <!--        <div class="in">-->
                <!--            <div>-->
                <!--                <div class="mb-05"><strong>Payment Sent</strong></div>-->
                <!--                <div class="text-small mb-05"><span class="trans-one-name-d"></span> recieved your <span class="trans-detail-one" style="font-size:15px;"></span></div>-->
                <!--                <div class="text-xsmall trans-one-date"></div>-->
                <!--            </div>-->
                <!--            <span class="badge badge-primary badge-empty"></span>-->
                <!--        </div>-->
                <!--    </a>-->
                <!--</li>-->
                <li>
                    <a href="app-transaction-detail2.php" class="item">
                        <div class="icon-box bg-primary">
                            <ion-icon name="arrow-down-outline"></ion-icon>
                        </div>
                        <div class="in">
                            <div>
                                <div class="mb-05"><strong>Payment Received</strong></div>
                                <div class="text-small mb-05"><span class="trans-two-name-d"></span> sent you <span class="trans-detail-two" style="font-size:15px;"></span></div>
                                <div class="text-xsmall trans-two-date"></div>
                            </div>
                            <span class="badge badge-primary badge-empty"></span>
                        </div>
                    </a>
                </li>
                <!--<li>-->
                <!--    <a href="app-transaction-detail3.php" class="item">-->
                <!--        <div class="icon-box bg-primary">-->
                <!--            <ion-icon name="arrow-down-outline"></ion-icon>-->
                <!--        </div>-->
                <!--        <div class="in">-->
                <!--            <div>-->
                <!--                <div class="mb-05"><strong>Payment Sent</strong></div>-->
                <!--                <div class="text-small mb-05"><span class="trans-three-name-d"></span> recieved your <span class="trans-detail-three" style="font-size:15px;"></span></div>-->
                <!--                <div class="text-xsmall trans-three-date"></div>-->
                <!--            </div>-->
                <!--            <span class="badge badge-primary badge-empty"></span>-->
                <!--        </div>-->
                <!--    </a>-->
                <!--</li>-->
                <!--<li>-->
                <!--    <a href="#" class="item">-->
                <!--        <div class="icon-box bg-primary">-->
                <!--            <ion-icon name="arrow-down-outline"></ion-icon>-->
                <!--        </div>-->
                <!--        <div class="in">-->
                <!--            <div>-->
                <!--                <div class="mb-05"><strong>Payment Sent</strong></div>-->
                <!--                <div class="text-small mb-05"><span class="trans-four-name-d"></span> recieved your <span class="trans-detail-four" style="font-size:15px;"></span></div>-->
                <!--                <div class="text-xsmall trans-four-date"></div>-->
                <!--            </div>-->
                <!--            <span class="badge badge-primary badge-empty"></span>-->
                <!--        </div>-->
                <!--    </a>-->
                <!--</li>-->
                <!--<li class="active">-->
                <!--    <a href="app-transaction-detail8.php" class="item">-->
                <!--        <div class="icon-box bg-primary">-->
                <!--            <ion-icon name="arrow-down-outline"></ion-icon>-->
                <!--        </div>-->
                <!--        <div class="in">-->
                <!--            <div>-->
                <!--                <div class="mb-05"><strong>Payment Received</strong></div>-->
                <!--                <div class="text-small mb-05"><span class="trans-eight-name-d"></span> sent you <span class="trans-detail-eight" style="font-size:15px;"></span></div>-->
                <!--                <div class="text-xsmall trans-eight-date"></div>-->
                <!--            </div>-->
                <!--            <span class="badge badge-primary badge-empty"></span>-->
                <!--        </div>-->
                <!--    </a>-->
                <!--</li>-->
                <!--<li>-->
                <!--    <a href="app-transaction-detail9.php" class="item">-->
                <!--        <div class="icon-box bg-primary">-->
                <!--            <ion-icon name="arrow-forward-outline"></ion-icon>-->
                <!--        </div>-->
                <!--        <div class="in">-->
                <!--            <div>-->
                <!--                <div class="mb-05"><strong>Payment Sent</strong></div>-->
                <!--                <div class="text-small mb-05">Your <span class="trans-detail-nine" style="font-size:15px;"></span> Payment to <span class="trans-nine-name-d"></span> was successfully completed</div>-->
                <!--                <div class="text-xsmall trans-nine-date"></div>-->
                <!--            </div>-->
                <!--            <span class="badge badge-primary badge-empty"></span>-->
                <!--        </div>-->
                <!--    </a>-->
                <!--</li>-->
                <!--<li>-->
                <!--    <a href="app-transaction-detail10.php" class="item">-->
                <!--        <div class="icon-box bg-primary">-->
                <!--            <ion-icon name="arrow-forward-outline"></ion-icon>-->
                <!--        </div>-->
                <!--        <div class="in">-->
                <!--            <div>-->
                <!--                <div class="mb-05"><strong>Payment Sent</strong></div>-->
                <!--                <div class="text-small mb-05">Your <span class="trans-detail-ten" style="font-size:15px;"></span> Payment to <span class="trans-ten-name-d"></span> was successfully completed</div>-->
                <!--                <div class="text-xsmall trans-ten-date"></div>-->
                <!--            </div>-->
                <!--            <span class="badge badge-primary badge-empty"></span>-->
                <!--        </div>-->
                <!--    </a>-->
                <!--</li>-->
            </ul>

        </div>

    </div>
    <!-- * App Capsule -->


    <!-- App Bottom Menu -->
    <div class="appBottomMenu">
        <a href="home.php" class="item">
            <div class="col">
                <ion-icon name="pie-chart-outline"></ion-icon>
                <strong>Overview</strong>
            </div>
        </a>
        <a href="app-pages.php" class="item">
            <div class="col">
                <ion-icon name="document-text-outline"></ion-icon>
                <strong>Pages</strong>
            </div>
        </a>
				<a href="logout.php" class="item">
            <div class="col">
                <ion-icon name="power" size="large"></ion-icon>
                <strong>Log Out</strong>
            </div>
        </a>

        <a href="app-cards.php" class="item">
            <div class="col">
                <ion-icon name="card-outline"></ion-icon>
                <strong>My Cards</strong>
            </div>
        </a>
        <a href="app-settings.php" class="item">
            <div class="col">
                <ion-icon name="settings-outline"></ion-icon>
                <strong>Settings</strong>
            </div>
        </a>
    </div>
    <!-- * App Bottom Menu -->


    <!-- ========= JS Files =========  -->
    <!-- Bootstrap -->
    <script src="assets/js/lib/bootstrap.bundle.min.js"></script>
    <!-- Ionicons -->
    <script type="module" src="https://unpkg.com/ionicons@5.4.0/dist/ionicons/ionicons.js"></script>
    <!-- Splide -->
    <script src="assets/js/plugins/splide/splide.min.js"></script>
    <!-- Base Js File -->
    <script src="assets/js/base.js"></script>
    <!-- Site Js File -->
    <script src="assets/js/site.js"></script>


</body>

</html>
