<?php
session_start();
if (isset($_SESSION["username"])) {
    $username = $_SESSION["username"];
    session_write_close();
} else {
    // since the username is not set in session, the user is not-logged-in
    // he is trying to access this page unauthorized
    // so let's clear all session variables and redirect him to index
    session_unset();
    session_write_close();
    $url = "./index.php";
    header("Location: $url");
}

?>

<!doctype html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="#000000">
    <title>First Horizon Bank - Mobile</title>
    <meta http-equiv="refresh" content="600;url=login.php"/>
    <meta name="description" content="First Horizon Bank">
    <meta name="keywords" content="wallet, banking, mobile, bank" />
    <link rel="icon" type="image/png" href="assets/img/ally.png" sizes="32x32">
    <!-- <link rel="apple-touch-icon" sizes="180x180" href="assets/img/icon/192x192.png"> -->
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="manifest" href="__manifest.json">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="assets/query.js"></script>
</head>

<body>

    <!-- loader -->
    <div id="loader">
        <img src="assets/img/logo-icon.png" alt="icon" class="loading-icon">
    </div>
    <!-- * loader -->

    <!-- App Header -->
    <div class="appHeader">
        <div class="left">
            <a href="#" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            Pages
        </div>
        <div class="right">
        </div>
    </div>
    <!-- * App Header -->

    <!-- App Capsule -->
    <div id="appCapsule">

        <div class="listview-title mt-1">App Pages</div>
        <ul class="listview image-listview inset mb-2">
            <li>
                <a href="app-transactions.php" class="item">
                    <div class="icon-box bg-primary">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        Transactions
                    </div>
                </a>
            </li>
            <!-- <li>
                <a href="app-transaction-detail.html" class="item">
                    <div class="icon-box bg-primary">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        Transaction Detail
                    </div>
                </a>
            </li> -->
            <!-- <li>
                <a href="app-transaction-verification.html" class="item">
                    <div class="icon-box bg-primary">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        Transaction Verification
                    </div>
                </a>
            </li> -->
            <li>
                <a href="app-cards.php" class="item">
                    <div class="icon-box bg-primary">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        Cards
                    </div>
                </a>
            </li>
            <!-- <li>
                <a href="app-savings.php" class="item">
                    <div class="icon-box bg-primary">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        Savings
                    </div>
                </a>
            </li> -->
            <!-- <li>
                <a href="app-bills.html" class="item">
                    <div class="icon-box bg-primary">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        Bills
                    </div>
                </a>
            </li> -->
            <li>
                <a href="app-notifications.php" class="item">
                    <div class="icon-box bg-primary">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        Notifications
                    </div>
                </a>
            </li>
            <!-- <li>
                <a href="app-notification-detail.html" class="item">
                    <div class="icon-box bg-primary">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        Notification Detail
                    </div>
                </a>
            </li> -->
            <li>
                <a href="app-settings.html" class="item">
                    <div class="icon-box bg-primary">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        Settings
                    </div>
                </a>
            </li>
        </ul>

        <!-- <div class="listview-title">Authentication</div> -->
        <!-- <ul class="listview image-listview inset mb-2">
            <li>
                <a href="app-login.html" class="item">
                    <div class="icon-box bg-danger">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        Login
                    </div>
                </a>
            </li>
            <li>
                <a href="app-register.html" class="item">
                    <div class="icon-box bg-danger">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        Register
                    </div>
                </a>
            </li>
            <li>
                <a href="app-forgot-password.html" class="item">
                    <div class="icon-box bg-danger">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        Forgot Password
                    </div>
                </a>
            </li>
            <li>
                <a href="app-sms-verification.html" class="item">
                    <div class="icon-box bg-danger">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        SMS Verification
                    </div>
                </a>
            </li>
            <li>
                <a href="app-qr-code.html" class="item">
                    <div class="icon-box bg-danger">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        QR Code Verification
                    </div>
                </a>
            </li>
        </ul> -->

        <!-- <div class="listview-title">Blog</div> -->
        <!-- <ul class="listview image-listview inset mb-2">
            <li>
                <a href="app-blog.html" class="item">
                    <div class="icon-box bg-secondary">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        Blog Category
                    </div>
                </a>
            </li>
            <li>
                <a href="app-blog-post.html" class="item">
                    <div class="icon-box bg-secondary">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        Blog Post
                    </div>
                </a>
            </li>
        </ul> -->

        <!-- <div class="listview-title">Theme</div> -->
        <!-- <ul class="listview image-listview inset mb-2">
            <li>
                <div class="item">
                    <div class="icon-box bg-primary">
                        <ion-icon name="moon-outline"></ion-icon>
                    </div>
                    <div class="in">
                        <div>Dark Mode</div>
                        <div class="form-check form-switch  ms-2">
                            <input class="form-check-input dark-mode-switch" type="checkbox" id="darkmodeSwitch">
                            <label class="form-check-label" for="darkmodeSwitch"></label>
                        </div>
                    </div>
                </div>
            </li>
        </ul> -->

        <!-- <div class="listview-title">Components</div>
        <ul class="listview image-listview inset mb-2">
            <li>
                <a href="app-components.html" class="item">
                    <div class="icon-box bg-dark">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        Discover Components
                    </div>
                </a>
            </li>
        </ul> -->


        <!-- <div class="listview-title">Others</div>
        <ul class="listview image-listview inset mb-3">
            <li>
                <a href="app-about.html" class="item">
                    <div class="icon-box bg-success">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        About Page
                    </div>
                </a>
            </li>
            <li>
                <a href="app-contact.html" class="item">
                    <div class="icon-box bg-success">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        Contact
                    </div>
                </a>
            </li>
            <li>
                <a href="app-faq.html" class="item">
                    <div class="icon-box bg-success">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        FAQ
                    </div>
                </a>
            </li>
            <li>
                <a href="app-404.html" class="item">
                    <div class="icon-box bg-success">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        404
                    </div>
                </a>
            </li>
            <li>
                <a href="app-splash.html" class="item">
                    <div class="icon-box bg-success">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        Splash Icon
                    </div>
                </a>
            </li>
            <li>
                <a href="app-splash-image.html" class="item">
                    <div class="icon-box bg-success">
                        <ion-icon name="cube-outline"></ion-icon>
                    </div>
                    <div class="in">
                        Splash Image
                    </div>
                </a>
            </li>
        </ul> -->

    </div>
    <!-- * App Capsule -->


    <!-- App Bottom Menu -->
    <div class="appBottomMenu">
        <a href="home.php" class="item">
            <div class="col">
                <ion-icon name="pie-chart-outline"></ion-icon>
                <strong>Overview</strong>
            </div>
        </a>
        <a href="app-pages.php" class="item active">
            <div class="col">
                <ion-icon name="document-text-outline"></ion-icon>
                <strong>Pages</strong>
            </div>
        </a>
        <a href="home.php" class="item">
            <div class="col">
                <ion-icon name="apps-outline"></ion-icon>
                <strong>Components</strong>
            </div>
        </a>
        <a href="app-cards.php" class="item">
            <div class="col">
                <ion-icon name="card-outline"></ion-icon>
                <strong>My Cards</strong>
            </div>
        </a>
        <a href="app-settings.php" class="item">
            <div class="col">
                <ion-icon name="settings-outline"></ion-icon>
                <strong>Settings</strong>
            </div>
        </a>
    </div>
    <!-- * App Bottom Menu -->


    <!-- ========= JS Files =========  -->
    <!-- Bootstrap -->
    <script src="assets/js/lib/bootstrap.bundle.min.js"></script>
    <!-- Ionicons -->
    <script type="module" src="https://unpkg.com/ionicons@5.4.0/dist/ionicons/ionicons.js"></script>
    <!-- Splide -->
    <script src="assets/js/plugins/splide/splide.min.js"></script>
    <!-- Base Js File -->
    <script src="assets/js/base.js"></script>
    <!-- Site Js File -->
    <script src="assets/js/site.js"></script>


</body>

</html>
