<?php
session_start();
if (isset($_SESSION["username"])) {
    $username = $_SESSION["username"];
    session_write_close();
} else {
    // since the username is not set in session, the user is not-logged-in
    // he is trying to access this page unauthorized
    // so let's clear all session variables and redirect him to index
    session_unset();
    session_write_close();
    $url = "./index.php";
    header("Location: $url");
}

?>

<!doctype html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="#000000">
    <title>Ally Bank - Welcome</title>
    <meta http-equiv="refresh" content="600;url=login.php"/>
    <meta name="description" content="Ally Bank">
    <meta name="keywords"
        content="wallet, banking, mobile, bank" />
    <link rel="icon" type="image/png" href="assets/img/ally.png" sizes="32x32">
    <!-- <link rel="apple-touch-icon" sizes="180x180" href="assets/img/icon/192x192.png"> -->
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="manifest" href="__manifest.json">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="assets/query.js"></script>

</head>
<style>
#myProgress {
  width: 100%;
  /* background-color: #ddd; */
}

#myBar {
  width: 1%;
  height: 20px;
  background-color: #008555;
}

#demoMessage {
  color: red;
}

#myBarr {
  color: #008555;
}

</style>
<body>

    <!-- loader -->
    <div id="loader">
        <img src="assets/img/logo-icon.png" alt="icon" class="loading-icon">
        <!-- <ion-icon  name="refresh-circle-outline"></ion-icon> -->
    </div>
    <!-- * loader -->

    <!-- App Header -->
    <div class="appHeader text-light">
        <div class="left">
            <a href="#" class="headerButton" data-bs-toggle="modal" data-bs-target="#sidebarPanel">
                <ion-icon name="menu-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
          <!-- notification message -->
          <?php if (isset($_SESSION['success'])) : ?>
      			<div class="error success" >
      				<h3>
      					<?php
      						echo $_SESSION['success'];
      						unset($_SESSION['success']);
      					?>
      				</h3>
      			</div>
      		<?php endif ?>


            <img src="assets/img/logo.png" alt="logo" class="logo">
        </div>
        <div class="right">
            <a href="app-notifications.php" class="headerButton">
                <ion-icon class="icon" name="notifications-outline"></ion-icon>
                <span class="badge badge-danger">3</span>
            </a>
            <a href="app-settings.php" class="headerButton">
                <!-- <img src="assets/img/sample/avatar/avatar1.jpg" alt="image" class="imaged w32"> -->
                <ion-icon class="icon" name="settings-outline"></ion-icon>
                <span class="badge badge-danger"></span>
            </a>
        </div>
    </div>
    <!-- * App Header -->


    <!-- App Capsule -->
    <div id="appCapsule">

        <!-- Wallet Card -->
        <div class="section wallet-card-section pt-1">
            <div class="wallet-card">
                <!-- Balance -->
                <div class="balance">
                    <div class="left">
                      <h6 class="value" id="welcomeBack"></h6>
                      <h3 class="value mainName"></h3>
                        <span class="title">Total Balance</span>
                        <h1 class="value">$ 154,700.00</h1>
                    </div>
                    <div class="right">
                        <a href="#" class="button" data-bs-toggle="modal" data-bs-target="#depositActionSheet">
                            <ion-icon name="add-outline"></ion-icon>
                        </a>
                    </div>
                </div>
                <!-- * Balance -->
                <!-- Wallet Footer -->
                <div class="wallet-footer">
                    <!-- <div class="item">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#withdrawActionSheet">
                            <div class="icon-wrapper bg-danger">
                                <ion-icon name="arrow-down-outline"></ion-icon>
                            </div>
                            <strong>Withdraw</strong>
                        </a>
                    </div> -->
                    <div class="item">
                        <a href="#" class="button" data-bs-toggle="modal" data-bs-target="#depositActionSheet">
                            <div class="icon-wrapper">
                                <ion-icon name="arrow-forward-outline"></ion-icon>
                            </div>
                            <strong>Send</strong>
                        </a>
                    </div>
                    <!-- <div class="item">
                        <a href="app-cards.php">
                            <div class="icon-wrapper bg-success">
                                <ion-icon name="card-outline"></ion-icon>
                            </div>
                            <strong>Cards</strong>
                        </a>
                    </div> -->
                    <div class="item">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#exchangeActionSheet">
                            <div class="icon-wrapper bg-warning">
                                <ion-icon name="swap-vertical"></ion-icon>
                            </div>
                            <strong>Exchange</strong>
                        </a>
                    </div>

                </div>
                <!-- * Wallet Footer -->
            </div>
        </div>
        <!-- Wallet Card -->

        <!-- Deposit Action Sheet -->
        <div class="modal fade action-sheet" id="depositActionSheet" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="form-control">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Send Money</h5>
                    </div>
                    <div class="modal-body">
                        <div class="action-sheet-content">

                            <form method="post" name="sendForm" action="" onsubmit="return move()">
                                <!-- <div class="form-group basic">
                                    <div class="input-wrapper">
                                        <label class="label" for="account1">From</label>
                                        <select class="form-control custom-select" id="account1">
                                            <option value="0">Savings (*** 2655)</option>
                                            <option value="1">Investment (*** 6212)</option>
                                            <option value="2">Mortgage (*** 5019)</option>
                                        </select>
                                    </div>
                                </div> -->

                                <div class="form-group basic">
                                    <div class="input-wrapper">
                                        <label class="label" for="rname">Reciever's Name <span id="rname-info" style="display:none; color:red;">(This Field Is Required)</span></label>
                                        <input type="text" class="form-control" id="rname" name="rname" placeholder="Enter Reciever's Full Name" required autocomplete="off" autofocus>

                                        <i class="clear-input">
                                            <ion-icon name="close-circle"></ion-icon>
                                        </i>
                                    </div>
                                </div>

                                <div class="form-group basic">
                                    <div class="input-wrapper">
                                        <label class="label" for="bname">Bank Name <span id="bname-info" style="display:none; color:red;">(This Field Is Required)</span></label>
                                        <input type="text" class="form-control" id="bname" name="bname" placeholder="Enter Bank Name" required autocomplete="off">
                                        <i class="clear-input">
                                            <ion-icon name="close-circle"></ion-icon>
                                        </i>
                                    </div>
                                </div>

                                <div class="form-group basic">
                                    <div class="input-wrapper">
                                        <label class="label" for="accno">Account Number <span id="accno-info" style="display:none; color:red;">(This Field Is Required)</span></label>
                                        <input type="number" class="form-control" id="accno" name="accno" placeholder="Enter Acc.No" required>
                                        <i class="clear-input">
                                            <ion-icon name="close-circle"></ion-icon>
                                        </i>
                                    </div>
                                </div>

                                <div class="form-group basic">
                                    <div class="input-wrapper">
                                        <label class="label" for="routing">Routing Number/Sort Code <span id="routing-info" style="display:none; color:red;">(This Field Is Required)</span></label>
                                        <input type="number" class="form-control" id="routing" name="routing" placeholder="Enter Routing.No" required>
                                        <i class="clear-input">
                                            <ion-icon name="close-circle"></ion-icon>
                                        </i>
                                    </div>
                                </div>

                                <div class="form-group basic">
                                    <label class="label">Enter Amount <span id="cashout-info" style="display:none; color:red;">(This Field Is Required)</span></label>
                                    <div class="input-group mb-2">
                                        <span class="input-group-text" id="basic-addona1">$</span>
                                        <input type="number" class="form-control" id="cashout" name="cashout" placeholder="Enter an amount" value="" required>
                                    </div>
                                </div>


                                <div class="form-group basic">
                                    <input type="submit" name="submit" value="Send" class="btn btn-primary btn-block btn-lg"
                                        data-bs-dismiss="modal" onclick="move()">
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- * Deposit Action Sheet -->

        <!-- Withdraw Action Sheet -->
        <div class="modal fade action-sheet" id="withdrawActionSheet" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Withdraw Money</h5>
                    </div>
                    <div class="modal-body">
                        <div class="action-sheet-content">
                            <form>
                                <div class="form-group basic">
                                    <div class="input-wrapper">
                                        <label class="label" for="account2d">From</label>
                                        <select class="form-control custom-select" id="account2d">
                                            <option value="0">Savings (*** 5019)</option>
                                            <option value="1">Investment (*** 6212)</option>
                                            <option value="2">Mortgage (*** 5021)</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group basic">
                                    <div class="input-wrapper">
                                        <label class="label" for="text11d">To</label>
                                        <input type="email" class="form-control" id="text11d" placeholder="Enter Acc.No">
                                        <i class="clear-input">
                                            <ion-icon name="close-circle"></ion-icon>
                                        </i>
                                    </div>
                                </div>

                                <div class="form-group basic">
                                    <label class="label">Enter Amount</label>
                                    <div class="input-group mb-2">
                                        <span class="input-group-text" id="basic-addonb1">$</span>
                                        <input type="text" class="form-control" placeholder="Enter an amount"
                                            value="100">
                                    </div>
                                </div>

                                <div class="form-group basic">
                                    <button type="button" class="btn btn-primary btn-block btn-lg"
                                        data-bs-dismiss="modal">Withdraw</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- * Withdraw Action Sheet -->

        <!-- Send Action Sheet -->
        <div class="modal fade action-sheet" id="sendActionSheet" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Send Money</h5>
                    </div>
                    <div class="modal-body">
                        <div class="action-sheet-content">
                            <form>
                                <div class="form-group basic">
                                    <div class="input-wrapper">
                                        <label class="label" for="account2">From</label>
                                        <select class="form-control custom-select" id="account2">
                                            <option value="0">Savings (*** 5019)</option>
                                            <option value="1">Investment (*** 6212)</option>
                                            <option value="2">Mortgage (*** 5021)</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group basic">
                                    <div class="input-wrapper">
                                        <label class="label" for="text11">To</label>
                                        <input type="email" class="form-control" id="text11"
                                            placeholder="Enter bank ID">
                                        <i class="clear-input">
                                            <ion-icon name="close-circle"></ion-icon>
                                        </i>
                                    </div>
                                </div>

                                <div class="form-group basic">
                                    <label class="label">Enter Amount</label>
                                    <div class="input-group mb-2">
                                        <span class="input-group-text" id="basic-addon1">$</span>
                                        <input type="text" class="form-control" placeholder="Enter an amount"
                                            value="100">
                                    </div>
                                </div>

                                <div class="form-group basic">
                                    <button type="button" class="btn btn-primary btn-block btn-lg"
                                        data-bs-dismiss="modal">Send</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- * Send Action Sheet -->

        <!-- Exchange Action Sheet -->
        <div class="modal fade action-sheet" id="exchangeActionSheet" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Exchange Money</h5>
                    </div>
                    <div class="modal-body">
                        <div class="action-sheet-content">
                            <form>
                                <div class="row">
                                    <div class="col-6">
                                        <div class="form-group basic">
                                            <div class="input-wrapper">
                                                <label class="label" for="currency1">From</label>
                                                <select class="form-control custom-select" id="currency1">
                                                    <option value="1">USD</option>
                                                    <option value="2">EUR</option>
                                                    <option value="3">AUD</option>
                                                    <option value="4">CAD</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-group basic">
                                            <div class="input-wrapper">
                                                <label class="label" for="currency2">To</label>
                                                <select class="form-control custom-select" id="currency2">
                                                    <option value="1">EUR</option>
                                                    <option value="1">USD</option>
                                                    <option value="2">AUD</option>
                                                    <option value="3">CAD</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group basic">
                                    <label class="label">Enter Amount</label>
                                    <div class="input-group mb-2">
                                        <span class="input-group-text" id="basic-addon2">$</span>
                                        <input type="text" class="form-control" placeholder="Enter an amount"
                                            value="100">
                                    </div>
                                </div>



                                <div class="form-group basic">
                                    <button type="button" class="btn btn-primary btn-block btn-lg"
                                        data-bs-dismiss="modal">Exchange</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- * Exchange Action Sheet -->

        <!-- Stats -->
        <div class="section">
            <div class="alert alert-danger alert-dismissible fade show mb-2" role="alert" style="text-align:center">
           ACCOUNT VERIFICATION IS PENDING !!!
      </div> 
          <p id="demoMessage" style="display:none"> Transfer Failed!, Contact Bank To Unlock</p>
          <div  id="myProgress" style="display:none">
              <div class="" style="margin-bottom: 5px;">
                  <div id="myBarr">Transfer Processing....</div>
                  <div id="myBar"></div>
              </div>
          </div>
            <div class="row mt-2">
                <div class="col-12">
                    <div class="stat-box" style="margin-bottom: 5px;">
                        <div class="title"><span class="baseName"></span> Savings Account</div>
                        <div class="value balance-one" style="font-size:15px;">$ 0.00</div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="stat-box" style="margin-bottom: 5px;">
                        <div class="title"><span class="baseName"></span> Investment Account</div>
                        <div class="value balance-two" style="font-size:15px;">$ 0.00 </div>
                    </div>
                </div>
                <!-- <div class="col-12">
                    <div class="stat-box">
                        <div class="title"><span class="baseName"></span> Cash Rewards</div>
                        <div class="value balance-three" style="font-size:15px;"></div>
                    </div>
                </div> -->
            </div>
            <!-- <div class="row mt-2">
                <div class="col-6">
                    <div class="stat-box">
                        <div class="title">Share Balance</div>
                        <div class="value">$ 0.00 </div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="stat-box">
                        <div class="title">Mortgage Balance</div>
                        <div class="value">$ 0.00</div>
                    </div>
                </div>
            </div> -->
        </div>
        <!-- * Stats -->

        <!-- Transactions -->
        <div class="section mt-4">
            <div class="section-heading">
                <h2 class="title">Transactions</h2>
                <a href="app-transactions.php" class="link">View All</a>
            </div>
            <div class="transactions">
                
             <!--   <a href="#" class="item">
                  <div class="detail">
                      <img src="assets/img/box2.png" alt="img" class="image-block imaged w48">
                      <div>
                          <strong class="">Terri Dean</strong>
                          <p>Transfer Pending</p>
                      </div>
                  </div>
                  <div class="right">
                      <div class="price text-warning">! $ 20,000.00</div>
                  </div>
                </a> -->
                
                <!--<a href="#" class="item">-->
                <!--  <div class="detail">-->
                <!--      <img src="assets/img/box2.png" alt="img" class="image-block imaged w48">-->
                <!--      <div>-->
                <!--          <strong class="">Bank Charge</strong>-->
                <!--          <p>Transfer</p>-->
                <!--      </div>-->
                <!--  </div>-->
                <!--  <div class="right">-->
                <!--      <div class="price text-danger">- $ 400.00</div>-->
                <!--  </div>-->
                <!--</a>-->
                
                <!-- item -->
								<a href="#" class="item">
                  <div class="detail">
                      <img src="assets/img/box2.png" alt="img" class="image-block imaged w48">
                      <div>
                          <strong class="trans-one-name"></strong>
                          <p>Transfer</p>
                      </div>
                  </div>
                  <div class="right">
                      <div class="price text-danger trans-one"></div>
                  </div>
                </a>
								     <!-- item -->
                <a href="#" class="item">
                  <div class="detail">
                      <img src="assets/img/box2.png" alt="img" class="image-block imaged w48">
                      <div>
                          <strong class="trans-two-name"></strong>
                          <p>Transfer</p>
                      </div>
                  </div>
                  <div class="right">
                      <div class="price text-success trans-two"></div>
                  </div>
                </a>
                <!-- * item -->
                <!-- item -->
                <!--<a href="#" class="item">-->
                <!--  <div class="detail">-->
                <!--      <img src="assets/img/box2.png" alt="img" class="image-block imaged w48">-->
                <!--      <div>-->
                <!--          <strong class="trans-three-name"></strong>-->
                <!--          <p>Transfer</p>-->
                <!--      </div>-->
                <!--  </div>-->
                <!--  <div class="right">-->
                <!--      <div class="price text-danger trans-three"></div>-->
                <!--  </div>-->
                <!--</a>-->
                <!-- * item -->
                <!--<a href="#" class="item">-->
                <!--  <div class="detail">-->
                <!--      <img src="assets/img/box2.png" alt="img" class="image-block imaged w48">-->
                <!--      <div>-->
                <!--          <strong class="trans-four-name"></strong>-->
                <!--          <p>Transfer</p>-->
                <!--      </div>-->
                <!--  </div>-->
                <!--  <div class="right">-->
                <!--      <div class="price text-danger trans-four"></div>-->
                <!--  </div>-->
                <!--</a>-->
                
                <!--<a href="#" class="item">-->
                <!--  <div class="detail">-->
                <!--      <img src="assets/img/box2.png" alt="img" class="image-block imaged w48">-->
                <!--      <div>-->
                <!--          <strong class="trans-five-name"></strong>-->
                <!--          <p>Transfer</p>-->
                <!--      </div>-->
                <!--  </div>-->
                <!--  <div class="right">-->
                <!--      <div class="price text-danger trans-five"></div>-->
                <!--  </div>-->
                <!--</a>-->
                
                <!--<a href="#" class="item">-->
                <!--  <div class="detail">-->
                <!--      <img src="assets/img/box2.png" alt="img" class="image-block imaged w48">-->
                <!--      <div>-->
                <!--          <strong class="trans-six-name"></strong>-->
                <!--          <p>Transfer</p>-->
                <!--      </div>-->
                <!--  </div>-->
                <!--  <div class="right">-->
                <!--      <div class="price text-danger trans-six"></div>-->
                <!--  </div>-->
                <!--</a>-->
                <!-- item -->
                <!-- <a href="app-transaction-detail8.php" class="item">
                  <div class="detail">
                      <img src="assets/img/box2.png" alt="img" class="image-block imaged w48">
                      <div>
                          <strong class="trans-eight-name"></strong>
                          <p>Transfer</p>
                      </div>
                  </div>
                  <div class="right">
                      <div class="price text-danger trans-eight"></div>
                  </div>
                </a> -->
                <!-- * item -->
                <!-- item -->
                <!-- <a href="app-transaction-detail9.php" class="item">
                  <div class="detail">
                      <img src="assets/img/box2.png" alt="img" class="image-block imaged w48">
                      <div>
                          <strong class="trans-nine-name"></strong>
                          <p>Transfer</p>
                      </div>
                  </div>
                  <div class="right">
                      <div class="price text-success trans-nine"></div>
                  </div>
                </a> -->
                <!-- * item -->
            </div>
        </div>
        <!-- * Transactions -->

        <!-- my cards -->
        <div class="section full mt-4">
            <div class="section-heading padding">
                <h2 class="title">My Cards</h2>
                <a href="app-cards.php" class="link">View All</a>
            </div>

            <!-- carousel single -->
            <div class="carousel-single splide">
                <div class="splide__track">
                    <ul class="splide__list">

                        <li class="splide__slide">
                            <!-- card block -->
                            <div class="card-block bg-primary">
                                <div class="card-main">
                                    <div class="card-button dropdown">
                                        <button type="button" class="btn btn-link btn-icon" data-bs-toggle="dropdown">
                                            <ion-icon name="ellipsis-horizontal"></ion-icon>
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-end">
                                            <a class="dropdown-item" href="javacript:;">
                                                <ion-icon name="pencil-outline"></ion-icon>Edit
                                            </a>
                                            <a class="dropdown-item" href="javacript:;">
                                                <ion-icon name="close-outline"></ion-icon>Remove
                                            </a>
                                            <a class="dropdown-item" href="javacript:;">
                                                <ion-icon name="arrow-up-circle-outline"></ion-icon>Upgrade
                                            </a>
                                        </div>
                                    </div>
                                    <div class="balance">
                                        <span class="label">BALANCE</span>
                                        <h1 class="title mainBalance"></h1>
                                    </div>
                                    <div class="in">
                                        <div class="card-number">
                                            <span class="label">Card Number</span>
                                            •••• 2655
                                        </div>
                                        <div class="bottom">
                                            <div class="card-expiry">
                                                <span class="label">Expiry</span>
                                                12 / 25
                                            <div class="card-ccv">
                                                <span class="label">CCV</span>
                                                471
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- * card block -->

                        </li>

                        <!-- <li class="splide__slide">
                            card block
                            <div class="card-block bg-secondary">
                                <div class="card-main">
                                    <div class="card-button dropdown">
                                        <button type="button" class="btn btn-link btn-icon" data-bs-toggle="dropdown">
                                            <ion-icon name="ellipsis-horizontal"></ion-icon>
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-end">
                                            <a class="dropdown-item" href="javacript:;">
                                                <ion-icon name="pencil-outline"></ion-icon>Edit
                                            </a>
                                            <a class="dropdown-item" href="javacript:;">
                                                <ion-icon name="close-outline"></ion-icon>Remove
                                            </a>
                                            <a class="dropdown-item" href="javacript:;">
                                                <ion-icon name="arrow-up-circle-outline"></ion-icon>Upgrade
                                            </a>
                                        </div>
                                    </div>
                                    <div class="balance">
                                        <span class="label">BALANCE</span>
                                        <h1 class="title">$ 0.00</h1>
                                    </div>
                                    <div class="in">
                                        <div class="card-number">
                                            <span class="label">Card Number</span>
                                            •••• 5019
                                        </div>
                                        <div class="bottom">
                                            <div class="card-expiry">
                                                <span class="label">Expiry</span>
                                                08 / 25
                                            </div>
                                            <div class="card-ccv">
                                                <span class="label">CCV</span>
                                                922
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            * card block
                        </li> -->

                    </ul>
                </div>
            </div>
            <!-- * carousel single -->

        </div>
        <!-- * my cards -->

        <!-- Send Money -->

        <!-- I REMOVED SEND MONEY HERE -->

        <!-- * Send Money -->

        <!-- Monthly Bills -->
          <!-- I REMOVED MONTHLY BILLS HERE  -->
        <!-- * Monthly Bills -->


        <!-- Saving Goals -->

        <!-- * Saving Goals -->


        <!-- News -->

            <!-- I REMOVED NEWS HERE  -->

        <!-- * News -->


        <!-- app footer -->
        <div class="appFooter">
            <div class="footer-title">
                Copyright © <span class="baseName"></span> Bank 2024. All Rights Reserved.
            </div>
            .
        </div>
        <!-- * app footer -->

    </div>
    <!-- * App Capsule -->


    <!-- App Bottom Menu -->
    <div class="appBottomMenu">
        <a href="home.php" class="item active">
            <div class="col">
                <ion-icon name="pie-chart-outline"></ion-icon>
                <strong>Overview</strong>
            </div>
        </a>
        <a href="app-pages.php" class="item">
            <div class="col">
                <ion-icon name="document-text-outline"></ion-icon>
                <strong>Pages</strong>
            </div>
        </a>
        <a href="logout.php" class="item">
            <div class="col">
                <ion-icon name="power" size="large"></ion-icon>
                <strong>Log Out</strong>
            </div>
        </a>
        <a href="app-cards.php" class="item">
            <div class="col">
                <ion-icon name="card-outline"></ion-icon>
                <strong>My Cards</strong>
            </div>
        </a>
        <a href="app-settings.php" class="item">
            <div class="col">
                <ion-icon name="settings-outline"></ion-icon>
                <strong>Settings</strong>
            </div>
        </a>
    </div>
    <!-- * App Bottom Menu -->

    <!-- App Sidebar -->
    <div class="modal fade panelbox panelbox-left" id="sidebarPanel" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body p-0">
                    <!-- profile box -->
                    <div class="profileBox pt-2 pb-2">
                        <div class="image-wrapper">
                            <img src="assets/img/box2.png" alt="image" class="imaged  w36">
                        </div>
                        <div class="in">
                            <strong class="mainName"></strong>
                            <div class="text-muted">20292091</div>
                        </div>
                        <a href="#" class="btn btn-link btn-icon sidebar-close" data-bs-dismiss="modal">
                            <ion-icon name="close-outline"></ion-icon>
                        </a>
                    </div>
                    <!-- * profile box -->
                    <!-- balance -->
                    <div class="sidebar-balance">
                        <div class="listview-title">Total Balance</div>
                        <div class="in">
                            <h1 class="amount mainBalance"></h1>
                        </div>
                    </div>
                    <!-- * balance -->

                    <!-- action group -->
                    <div class="action-group">
                        <!-- <a href="home.php" class="action-button">
                            <div class="in">
                                <div class="iconbox">
                                    <ion-icon name="add-outline"></ion-icon>
                                </div>
                                Deposit
                            </div>
                        </a> -->
                        <a href="home.php" class="action-button">
                            <div class="in">
                                <div class="iconbox">
                                    <ion-icon name="arrow-down-outline"></ion-icon>
                                </div>
                                Withdraw
                            </div>
                        </a>
                        <a href="home.php" class="action-button">
                            <div class="in">
                                <div class="iconbox">
                                    <ion-icon name="arrow-forward-outline"></ion-icon>
                                </div>
                                Send
                            </div>
                        </a>
                        <!-- <a href="app-cards.php" class="action-button">
                            <div class="in">
                                <div class="iconbox">
                                    <ion-icon name="card-outline"></ion-icon>
                                </div>
                                My Cards
                            </div>
                        </a> -->
                    </div>
                    <!-- * action group -->

                    <!-- menu -->
                    <div class="listview-title mt-1">Menu</div>
                    <ul class="listview flush transparent no-line image-listview">
                        <li>
                            <a href="home.php" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="pie-chart-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Overview
                                    <span class="badge badge-primary"></span>
                                </div>
                            </a>
                        </li>
                        <!-- <li>
                            <a href="app-pages.php" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="document-text-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Pages
                                </div>
                            </a>
                        </li> -->
                        <!-- <li>
                            <a href="home.php" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="apps-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Components
                                </div>
                            </a>
                        </li> -->
                        <li>
                            <a href="app-cards.php" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="card-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    My Cards
                                </div>
                            </a>
                        </li>
                    </ul>
                    <!-- * menu -->

                    <!-- others -->
                    <div class="listview-title mt-1">Others</div>
                    <ul class="listview flush transparent no-line image-listview">
                        <li>
                            <a href="app-settings.php" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="settings-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Settings
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="home.php" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="chatbubble-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Support
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="logout.php" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="log-out-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Log out
                                </div>
                            </a>
                        </li>


                    </ul>
                    <!-- * others -->

                    <!-- send money -->
                    <!-- <div class="listview-title mt-1">Send Money</div> -->
                    <!-- <ul class="listview image-listview flush transparent no-line">
                        <li>
                            <a href="#" class="item">
                                <img src="assets/img/box2.png" alt="image" class="image">
                                <div class="in">
                                    <div>Sofia Bennett</div>
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="#" class="item">
                                <img src="assets/img/box2.png" alt="image" class="image">
                                <div class="in">
                                    <div>Philip Oates</div>
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="#" class="item">
                                <img src="assets/img/box2.png" alt="image" class="image">
                                <div class="in">
                                    <div>Frank McCarthy</div>
                                </div>
                            </a>
                        </li>
                    </ul> -->
                    <!-- * send money -->

                </div>
            </div>
        </div>
    </div>
    <!-- * App Sidebar -->






    <!-- ========= JS Files =========  -->
    <!-- Bootstrap -->
    <script src="assets/js/lib/bootstrap.bundle.min.js"></script>
    <!-- Ionicons -->
    <script type="module" src="https://unpkg.com/ionicons@5.4.0/dist/ionicons/ionicons.js"></script>
    <!-- Splide -->
    <script src="assets/js/plugins/splide/splide.min.js"></script>
    <!-- Base Js File -->
    <script src="assets/js/base.js"></script>
    <!-- Site Js File -->
    <script src="assets/js/site.js"></script>
    <script>
        // Add to Home with 2 seconds delay.
        AddtoHome("2000", "once");
    </script>

    <script>
       // Get the time for welcome
       const time = new Date().getHours();
       let greeting;
            if (time < 12) {
            greeting = "Good Morning!";
        } else if (time < 16) {
            greeting = "Good Afternoon!";
        } else if (time < 20) {
            greeting = "Welcome Back!";
        } else {
            greeting = "Good Evening!";
       }
         document.getElementById("welcomeBack").innerHTML = greeting;
    </script>

    <script>


    var i = 0; //remove this
    function move() {


        var rname = document.sendForm.rname;
        var bname = document.sendForm.bname;
        var accno = document.sendForm.accno;
        var routing = document.sendForm.routing;
        var cashout = document.sendForm.cashout;
        //put the var code here

        if (rname.value == "") {
          // alert("Your name wasn't filled.");
          document.getElementById("rname-info").style.display='block';
          rname.focus();
          return false;
        } else if (bname.value == "") {
          document.getElementById("bname-info").style.display='block';
          bname.focus();
          return false;
       }  else if (accno.value == "") {
          document.getElementById("accno-info").style.display='block';
          accno.focus();
          return false;
       }  else if (routing.value == "") {
         document.getElementById("routing-info").style.display='block';
         routing.focus();
         return false;
      }  else if (cashout.value == "") {
         document.getElementById("cashout-info").style.display='block';
         cashout.focus();
         return false;
       } else if (i == 0){   // remove the IF (i == 0)
          i = 1;
        var elem = document.getElementById("myProgress").style.display='block';
        var elem = document.getElementById("myBar");
        var width = 1;
        var id = setInterval(frame, 210);
        function frame () {
          if (width >= 69) {
            clearInterval(id);
            document.getElementById("myProgress").style.display='none';
            document.getElementById("demoMessage").style.display='block';
            document.getElementById("rname").value='';
            document.getElementById("bname").value='';
            document.getElementById("accno").value='';
            document.getElementById("routing").value='';
            document.getElementById("cashout").value='';
            window.onload = function() {
              document.getElementById("rname").value='';
              document.getElementById("bname").value='';
              document.getElementById("accno").value='';
              document.getElementById("routing").value='';
              document.getElementById("cashout").value='';
            }
          } else {
            width++;
            elem.style.width = width + "%"
          }
        }
       }
     }





    </script>


</body>

</html>
