<?php
use Phppot\Member;

if (! empty($_POST["login-btn"])) {
    require_once __DIR__ . '/Model/Member.php';
    $member = new Member();
    $loginResult = $member->loginMember();
}
?>
<HTML>

<HEAD>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
  <meta name="apple-mobile-web-app-capable" content="yes" />
  <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
  <meta name="theme-color" content="#000000">
  <title>Ally Bank - Login</title>
  <meta name="description" content="Ally Bank">
  <meta name="keywords" content="wallet, banking, mobile, bank" />
  <link rel="icon" type="image/png" href="assets/img/ally.png" sizes="32x32">
  <!-- <link rel="apple-touch-icon" sizes="180x180" href="assets/img/icon/192x192.png"> -->
  <link rel="stylesheet" href="assets/css/style.css">
  <link rel="manifest" href="__manifest.json">
  <script src="vendor/jquery/jquery-3.3.1.js" type="text/javascript"></script>
</HEAD>

<BODY>

  <!-- App Header -->
  <div class="appHeader no-border transparent position-absolute">
      <div class="left">
          <a href="#" class="headerButton goBack">
              <ion-icon name="chevron-back-outline"></ion-icon>
          </a>
      </div>
      <img style="width:60px; height:35px;" src="assets/img/loginlogo.png" alt="logo" class="">
      <div class="pageTitle"></div>
      <div class="right">
      </div>
  </div>
  <!-- * App Header -->

 <!-- App Capsule -->
  <div id="appCapsule">

    <div class="section mt-2 text-center">
        <h1>Log in</h1>
        <!-- <h4>Fill the form to log in</h4> -->
    </div>



    <div class="section mb-5 p-2">

        <form name="login" action="" method="post" onsubmit="return loginValidation()">
          <?php if(!empty($loginResult)){?>
          <div class="error-msg"><?php echo $loginResult;?></div>
          <?php }?>
      <div class="card">
        <div class="card-body pb-1">
          <div class="form-group basic">
            <div class="input-wrapper">
              <div class="label">
                Username<span class="required error" id="username-info"></span>
              </div>
              <input class="form-control" type="text" name="username" id="username">
            </div>
          </div>
          <div class="form-group basic">
            <div class="input-wrapper">
              <div class="label">
                Password<span class="required error" id="login-password-info"></span>
              </div>
              <input class="form-control" type="password" name="login-password" id="login-password">
            </div>
          </div>
        </div>
      </div>

      <div class="form-links mt-2">
          <div>
              <a href="#">Register Now</a>
          </div>
          <div><a href="#" class="text-muted">Forgot Password?</a></div>
      </div>

          <div class="form-button-group  transparent">
            <input class="btn btn-primary btn-block btn-lg" type="submit" name="login-btn" id="login-btn" value="Login">
          </div>
        </form>
    </div>
  </div>

  <script>
    function loginValidation() {
      var valid = true;
      $("#username").removeClass("error-field");
      $("#password").removeClass("error-field");

      var UserName = $("#username").val();
      var Password = $('#login-password').val();

      $("#username-info").html("").hide();

      if (UserName.trim() == "") {
        $("#username-info").html("required.").css("color", "#ee0000").show();
        $("#username").addClass("error-field");
        valid = false;
      }
      if (Password.trim() == "") {
        $("#login-password-info").html("required.").css("color", "#ee0000").show();
        $("#login-password").addClass("error-field");
        valid = false;
      }
      if (valid == false) {
        $('.error-field').first().focus();
        valid = false;
      }
      return valid;
    }
  </script>
</BODY>

</HTML>
